/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 8
* Execution Risk by State: Twelve Largest States
****************************************************************************/

clear
set mat 800
cd "..."
use "StatePanel.dta", clear

egen size=rank(popul) if year==2000, field
tomode size, by(st) replace
tab st if size<=12
sort stid year
gen exec_mur=execs/l.murders
#delimit;
twoway 
	(line exec_mur year if st=="CA", sort lpattern(solid))
	(line exec_mur year if st=="TX", sort lpattern(dash))
	(line exec_mur year if st=="NY", sort lpattern(dot))
	(line exec_mur year if st=="FL", sort lpattern(tight_dot))
	(line exec_mur year if st=="IL", sort lpattern(longdash))
	(line exec_mur year if st=="PA", sort lpattern(vshortdash))
	(line exec_mur year if st=="OH", sort lpattern(shortdash_dot))
	(line exec_mur year if st=="MI", sort lpattern(longdash_dot))
	(line exec_mur year if st=="NJ", sort lpattern(dash_dot))
	(line exec_mur year if st=="GA", sort lpattern("__--"))
	(line exec_mur year if st=="NC", sort lpattern("..--"))
	(line exec_mur year if st=="VA", sort lpattern("..__")) if year<=2002,
title("Executions Risk by State: 12 Largest States")
ytitle("Annual Executions per Homicide")
xtitle("Year")
xlabel(1934 1940 1950 1960 1970 1980 1990 2002)
legend(position(2) ring(0))
legend(rows(3))
legend(order(1 "CA" 2 "TX" 3 "NY" 4 "FL" 5 "IL" 6 "PA" 7 "OH" 8 "MI" 9 "NJ" 10 "GA" 11 "NC" 12 "VA"))
legend(region(fcolor(none)))
xsize(10) ysize(7.5)

;
